/***************************************************************************
 *   Copyright (C) 2006 by PM   *
 *      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "an2131.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <getopt.h>
#include <errno.h>
#include <usb.h>

usb_dev_handle *udev;

an2131::an2131()
{

}

an2131::~an2131()
{
}

/*
 * the function returns handle to device spezified
 * by filename if device path pointer in filename
 * isn't zero. idVen and idProd are ignored in this case.
 * But if filename is zero, we return handle to device
 * specified by idVen and idProd.
 * If no device found, return (-1).
 */
usb_dev_handle* an2131::get_device_handle (struct dev_id id, const char *filename)
{
  struct usb_bus *bus;
  struct usb_device *dev;
  char dev_path[15];


  for (bus = usb_busses; bus; bus = bus->next)
    for (dev = bus->devices; dev; dev = dev->next)
      {
    //int i, ret;
    //char string[256];
    if (filename)
      {
        snprintf (dev_path, sizeof (dev_path) - 1, "%s/%s",
	      bus->dirname, dev->filename);
        printf ("dev: %s\n", dev_path);
        if (strstr (filename, (const char *) dev_path))
          {
	printf ("get handle for %s\n", dev_path);
	return usb_open (dev);
          }
      }
    else if (dev->descriptor.idVendor == id.idVen
	 && dev->descriptor.idProduct == id.idProd)
      {
        /*
           printf ("bus/device  idVendor/idProduct\n");
           printf ("%s/%s     %04X/%04X\n", bus->dirname, dev->filename,\
           dev->descriptor.idVendor, dev->descriptor.idProduct);
         */
        return usb_open (dev);
      }
      }
  return (usb_dev_handle *) (-1);
}

int an2131::open() 
{
	struct dev_id id;
	char *dev_path = NULL;
	int ret = 0;

	// default device ids (Cypress EZ-USB)
	strncpy(id.id_str,"547/2131/*", 10);
	id.idVen = 0x547;
	id.idProd = 0x2131;

	usb_init();

	usb_find_busses();
	usb_find_devices();

	udev = get_device_handle (id, dev_path);
	if (udev == (usb_dev_handle *) (-1))
	{
      fprintf (stderr, "no %s usb device found...\n", dev_path ? dev_path : id.id_str);
      return(1);
    }

  if ((ret = usb_set_configuration (udev, 1)) < 0)
    {
      fprintf (stderr, "usb_set_configuration 1: %s\n\n", strerror (errno));
      return(1);
    }

  if ((ret = usb_claim_interface (udev, 0)) < 0)
    {
      fprintf (stderr, "usb_claim_interface 0: %s\n\n", strerror (errno));
      return(1);
    }

  if ((ret = usb_set_altinterface (udev, 1)) < 0)
    {
      fprintf (stderr, "usb_set_altinterface 1: %s\n\n", strerror (errno));
      return(1);
    }

	return(0);
} 

int an2131::close() 
{
	int ret = 0;

	if( ret = usb_release_interface (udev, 0) )
	{
		fprintf (stderr, "usb_release_interface failed: %s\n\n", strerror(errno));
		return(1);
	}

	if (ret = usb_close (udev) ) 
	{
		fprintf (stderr, "usb_close failed: %s\n\n", strerror(errno));
		return(1);
	}

	return(ret);
}

int an2131::read_data()
{
	int ret = 0;
	int size = 64;

	
   if (ret = usb_bulk_read(udev, 0x02, (char *) &pipe01, size, 2000) < 0) 
	{
		fprintf (stderr, "usb_bulk_read failed: %s\n\n", strerror(errno));
		return(1);
	}

   if (ret = usb_bulk_read(udev, 0x04, (char *) &pipe03, size, 2000) < 0) 
	{
		fprintf (stderr, "usb_bulk_read failed: %s\n\n", strerror(errno));
		return(1);
	}

	return(ret);
}

int an2131::read_sensor_names()
{
	int i,j;
	int ret = 0;
	int size = 64;

	for (i = 0; i < 8; i++) 
	{
		if (ret = usb_bulk_read(udev, 0x06, (char *) &pipe05, size, 2000) < 0) 
		{
			fprintf (stderr, "usb_bulk_read failed: %s\n\n", strerror(errno));
			return(1);
		}
		strncpy(sensorname[pipe05.index], pipe05.name, 13);
		sensorname[pipe05.index][13] = 0x00; //terminate string
	}
}

int an2131::write_data()
{
	int ret, size = 64;
	
   if (ret = usb_bulk_write(udev, 0x02, (char *) &pipe02, size, 300) < 0) 
	{
		fprintf (stderr, "usb_bulk_write failed: %s\n\n", strerror(errno));
		return(1);
	}

//	printf("%02X \n", pipe02.lower_fan_limit);


	return(ret);
}

