/***************************************************************************
 *   Copyright (C) 2006 by PM   *
 *      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "an2131.h"

#include <qtable.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qtimer.h>
#include <qwt_counter.h>

#include "kfcwidget.h"

an2131 an2131i;
bool pause_update=0;

kfcWidget::kfcWidget(QWidget* parent, const char* name, WFlags fl) : kfcWidgetBase(parent,name,fl)
{
	// setup usb connection
	if (an2131i.open()) exit(1);

	an2131i.read_data();
	handle_static_data();

	QTimer *t = new QTimer( this );
	connect( t,  SIGNAL( timeout() ), this, SLOT( update_dyn_data() ) );
	t->start( 100, FALSE ); // 10 updates per second
}

kfcWidget::~kfcWidget()
{
	an2131i.close();
}

void kfcWidget::mode_change()
{
	an2131i.pipe02.control_mode = (unsigned char) mode -> currentItem();
	an2131i.write_data();
}

void kfcWidget::hysteresis_change()
{
	an2131i.pipe02.reg_hysteresis = (unsigned char) (hysteresis -> value() * 2);
	an2131i.write_data();
}

void kfcWidget::overtemp_change()
{
	an2131i.pipe02.overtemp = (unsigned char) (overtemp -> value() * 2);
	an2131i.write_data();
}

void kfcWidget::reg_speed_change()
{
	an2131i.pipe02.regulating_speed = (unsigned char) (reg_speed -> value() / 2);
	an2131i.write_data();
}

void kfcWidget::low_fan_lim_change()
{
	an2131i.pipe02.lower_fan_limit = (unsigned char) (low_fan_lim -> value());
	an2131i.write_data();
}

void kfcWidget::handle_static_data()
{
	int i;
	an2131i.read_sensor_names();

	// fill temperature table
	for ( int row = 0; row < tbl_temp->numRows(); row++ ) 
	{
		// insert sensornames
		tbl_temp -> setText(row, 0, an2131i.sensorname[row]);

		// insert alarmtemp
		tbl_temp -> setText(row, 2, QString::number(an2131i.pipe01.alarm_temp[row] * 0.5, 'f', 1));

		// insert sensor-fan configuration
		tbl_temp -> setText(row, 3, QString::number(an2131i.pipe01.sensor_fan_conf[row]));
	}

	// display mode
	mode -> setCurrentItem(an2131i.pipe01.control_mode);

	hysteresis -> setValue(an2131i.pipe01.reg_hysteresis * 0.5);
	overtemp -> setValue(an2131i.pipe01.overtemp * 0.5);
	reg_speed -> setValue(an2131i.pipe01.regulating_speed*2);

	low_fan_lim -> setValue(an2131i.pipe01.lower_fan_limit);

	//
	// prepare write block (create a copy of the current configuration)
	//

	an2131i.pipe02.save_type = 0x01; //save all to RAM
	for (i=0; i<8; i++) 
	{
		an2131i.pipe02.alarm_temp[i] = an2131i.pipe01.alarm_temp[i];
		an2131i.pipe02.sensor_fan_conf[i] = an2131i.pipe01.sensor_fan_conf[i];
	}
	for (i=0; i<3; i++) 
	{
		an2131i.pipe02.fan_pwm_duty_cycle_man[i] = an2131i.pipe03.fan_pwm_duty_cycle_man[i];
	}
	an2131i.pipe02.reg_hysteresis = an2131i.pipe01.reg_hysteresis;
	an2131i.pipe02.regulating_speed = an2131i.pipe01.regulating_speed;
	an2131i.pipe02.control_mode = an2131i.pipe01.control_mode;
	an2131i.pipe02.night_mode_req = an2131i.pipe01.night_mode_req; // ???
	an2131i.pipe02.overtemp = an2131i.pipe01.overtemp;
	an2131i.pipe02.lower_fan_limit = an2131i.pipe01.lower_fan_limit;
	an2131i.pipe02.alarm_value_flowsensor = an2131i.pipe03.alarm_value_flowsensor;
	for (i=0; i<33; i++) 
	{
		an2131i.pipe02.reserved[i] = 0x00;
	}
	an2131i.pipe02.padding[0] = 0x12;
	an2131i.pipe02.padding[1] = 0x93;
	an2131i.pipe02.padding[2] = 0xF1;
	an2131i.pipe02.padding[3] = 0x5C;
}

void kfcWidget::update_temp_section()
{
	// insert temperature
	double t;
	for ( int row = 0; row < tbl_temp->numRows(); row++ ) {
		if (!(an2131i.pipe01.sens_status & 2^row)) 
		{
			t = 0.5 * ( an2131i.pipe01.raw_sensor_data[row][0] & 0xFE) - 0.25 + (an2131i.pipe01.raw_sensor_data[row][3] - an2131i.pipe01.raw_sensor_data[row][2])/(double)an2131i.pipe01.raw_sensor_data[row][3];
			tbl_temp -> setText(row, 1, QString::number(t, 'f', 1));
		} 
		else 
		{
			tbl_temp -> setText(row, 1, "");
		}
	}
}

void kfcWidget::update_fan_table()
{
	// insert fan speed
	tbl_fans -> setText(0, 0, QString::number(an2131i.pipe03.fan_speed_1 * 15));
	tbl_fans -> setText(1, 0, QString::number(an2131i.pipe03.fan_speed_2 * 15));
	tbl_fans -> setText(2, 0, QString::number(an2131i.pipe03.fan_speed_3 * 15));

	
	for ( int row = 0; row < tbl_fans->numRows(); row++ ) 
	{
		// insert PWM duty cycle 
		if (an2131i.pipe03.fan_pwm_duty_cycle_man[row] == 0x00) 
		{
			tbl_fans -> setText(row, 1, "1:" + QString::number(an2131i.pipe03.fan_pwm_duty_cycle_auto[row])+"*");
		}
		else 
		{
			tbl_fans -> setText(row, 1, "1:" + QString::number(an2131i.pipe03.fan_pwm_duty_cycle_man[row]));
		}
		
		// fan acceleration
		tbl_fans -> setText(row, 2, QString::number(an2131i.pipe01.fan_acc[row]));
	}	
}

/*$SPECIALIZATION$*/
void kfcWidget::update_dyn_data()
{
	an2131i.read_data();

	update_temp_section();
	update_fan_table();
}


#include "kfcwidget.moc"

