/***************************************************************************
 *   Copyright (C) 2006 by PM   *
 *      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef AN2131_H
#define AN2131_H

/**
	@author PM
*/

#include <usb.h>

struct dev_id
{
  int idVen;
  int idProd;
  char id_str[PATH_MAX + 1];
  //int revision;
};

struct bulk02_IN
{
	unsigned char alarm_temp[8];			// valid: 0x32 - 0x82
	unsigned char sensor_fan_conf[8];	// valid: 0x00 - 0x07
	signed char fan_acc[3];					// valid: all
	unsigned char reg_hysteresis;			// valid: 0x01 - 0x14
	unsigned char regulating_speed;		// valid: 0x02 - 0x1e
	unsigned char fan_status;				// bitwise
	unsigned char control_mode;			// valid: 0x00 - 0x02
	unsigned char night_mode_req;			// valid: 0x00 - 0x01
	unsigned char failure_msg;				// valid: 0x00 - 0x09
	unsigned char overtemp;					// valid: 0x06 - 0x09
	unsigned char sensor_alarm_h;			// bitwise
	unsigned char sens_status;				// bitwise
	unsigned char sensor_alarm_nh;		// bitwise
	unsigned char lower_fan_limit;		// valid: 0x0A - 0x32
	unsigned char reset_sensor;			// bitwise
	unsigned char last_sensor;				// bitwise
	unsigned char raw_sensor_data[8][4];
};

struct bulk02_OUT
{
	unsigned char save_type;
	unsigned char alarm_temp[8];
	unsigned char sensor_fan_conf[8];
	unsigned char fan_pwm_duty_cycle_man[3];		// valid: 0x00 - 0x32
	unsigned char reg_hysteresis;						// valid: 0x01 - 0x14
	unsigned char regulating_speed;					// valid: 0x02 - 0x1e
	unsigned char control_mode;						// valid: 0x00 - 0x02
	unsigned char night_mode_req;						// valid: 0x00 - 0x01
	unsigned char overtemp;								// valid: 0x06 - 0x09
	unsigned char lower_fan_limit;					// valid: 0x0A - 0x32
	unsigned char alarm_value_flowsensor;			// valid: 0x00 - 0xFE
	unsigned char reserved[33];
	unsigned char padding[4];
};

struct bulk04_IN
{
	unsigned char reserved00;
	unsigned char fan_speed_1;
	unsigned char reserved01[9];
	unsigned char fan_speed_2;
	unsigned char reserved02[9];
	unsigned char fan_speed_3;
	unsigned char reserved03[8];
	unsigned char target_temp_deviation[8];
	unsigned char fan_pwm_duty_cycle_auto[3];		// valid: 0x00 - 0x31
	unsigned char fan_pwm_duty_cycle_man[3];		// valid: 0x00 - 0x32
	unsigned char next_pwm_update;
	signed char sensor_i_factor[8];
	unsigned char speed_flowsensor;
	unsigned char alarm_value_flowsensor;
	unsigned char light_channels_status;
	unsigned char reserved04[7];
};

struct bulk06_IN
{
	char name[13];
	unsigned char reserved00[7];
	unsigned char index;
	unsigned char reserved01[43];
};

class an2131{
	public:
		bulk02_IN  pipe01;
		bulk02_OUT pipe02;
		bulk04_IN  pipe03;
		char sensorname[8][14];

		an2131();
		~an2131();
		int open();
		int close();
		int read_data();
		int read_sensor_names();
		int write_data();

	private:
		bulk06_IN pipe05;

		usb_dev_handle *get_device_handle (struct dev_id id, const char *filename);
};

// AN2131SC parameter and vendor reguests
#define EZUSB_RAM_SIZE	0x2000
#define FIRMWARE_LOAD	0xA0
#define VENDOR_RQ_OUT	0x40
#define VENDOR_RQ_IN		0xC0

#define CPUCS		0x7f92

#endif
